clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1011.dta, clear
capture log close
log using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\log_files\step5007.log, replace

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total


gen bwimf_grr_apw_1970=bwimf_grr_apw

gen shock_ld8 =  log(1+BW_ld8_1975 - BW_ld8_1970)*100

gen shock_rl  =  log(1+BW_rl_1975 - BW_rl_1970)*100
					
gen shock_tfp =  log(1+BW_tfp_1975 - BW_tfp_1970)*100	

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1 & year==1971, robust beta 
			
local R2_base=e(r2)
local ll_base=e(ll)

keep if e(sample)

			
*==============================================================
*					No fixed effects
*==============================================================

					
tempname 1 
postfile `1' str100 var_bloc ///
			str10 c_shock_ld8 str10 c_shock_rl str10 c_shock_tfp ///
			str10 c_bwimf_grr_apw_1970 str10 c_BW_newep_1970 ///				
			str10 c_WVS_index_1 str10 c_WVS_index_2 str10 c_WVS_index_3 ///
			using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\output_dta\temp_Table5007, replace every(1)
	
			
foreach var_bloc in ///
				"turnmig_rate" ///
				"share_age_0_24 share_age_55plus" ///
				"WVS_index_2" ///
				"year_school share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  hh_size home_own_rate netmig_rate urban_share_500_y1990 logY_ppp   mlog_road_density city_nuts capital" ///
				{			
				di "==============================="
				di "`var_bloc'"
					foreach var in 	shock_ld8 shock_rl shock_tfp ///
						bwimf_grr_apw_1970 BW_newep_1970 ///				
						WVS_index_1 WVS_index_2 WVS_index_3 ///	
						{
					


							* generate interactions
							capture drop inter_*
							local counter1=1
							foreach var_bloc_s of varlist `var_bloc' {
									capture drop inter_`counter1'
									gen inter_`counter1' = `var'*`var_bloc_s'
									local counter1=`counter1'+1
								}

							* run regression: baseline + interactions
							reg  ue2_hyst  ///
								turnmig_rate ///
								share_age_0_24 share_age_55plus ///	
								WVS_index_2 ///
								year_school ///		
								share_emp_primary_sector share_emp_secondary_sector  ///
								ic_EMP_share_female  hh_size home_own_rate ///		
								netmig_rate urban_share_500_y1990 ///
								logY_ppp  mlog_road_density city_nuts capital ///
								`var' ///
								[aw=pop_wgt]  if smpl2==1 & year==1971, robust 
							local R2_base=e(r2)	
						
				
							* run regression: baseline + interactions
							reg  ue2_hyst  ///
								turnmig_rate ///
								share_age_0_24 share_age_55plus ///	
								WVS_index_2 ///
								year_school ///		
								share_emp_primary_sector share_emp_secondary_sector  ///
								ic_EMP_share_female  hh_size home_own_rate ///		
								netmig_rate urban_share_500_y1990 ///
								logY_ppp  mlog_road_density city_nuts capital ///
								inter_* ///
								`var' ///
								[aw=pop_wgt]  if smpl2==1 & year==1971, robust  
						
							local R2_`var'=e(r2)
							local ll_`var'=e(ll)
							
							capture testparm inter_*
								local F_`var'=r(F)
								local p_`var'=round(r(p)*1000)/1000
								
								local t1=r(p) 

							local DR2_`var'=e(r2)-`R2_base'
							local Dll_`var'=e(ll)-`ll_base'
							
							if abs(`t1')<=0.1 {
									local c_`var'=string(`DR2_`var'',"%4.3f")+"*"
							}	
							if abs(`t1')<=0.05 {
									local c_`var'=string(`DR2_`var'',"%4.3f")+"**"
							}		
							if abs(`t1')<=0.01 {
									local c_`var'=string(`DR2_`var'',"%4.3f")+"***"
							}

							if abs(`t1')>0.1 {
									local c_`var'=string(`DR2_`var'',"%4.3f")
							}	
								
				}
				
				
				post `1' ("`var_bloc'") ///
								("`c_shock_ld8'") ("`c_shock_rl'") ("`c_shock_tfp'") ///
								("`c_bwimf_grr_apw_1970'") ("`c_BW_newep_1970'") ///				
								("`c_WVS_index_1'") ("`c_WVS_index_2'") ("`c_WVS_index_3'")

				
			
}					


postclose `1'



			
*==============================================================
*					Fixed effects
*==============================================================

					
tempname 1 
postfile `1' str100 var_bloc ///
			str10 c_shock_ld8 str10 c_shock_rl str10 c_shock_tfp ///
			str10 c_bwimf_grr_apw_1970 str10 c_BW_newep_1970 ///				
			str10 c_WVS_index_1 str10 c_WVS_index_2 str10 c_WVS_index_3 ///
			using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\output_dta\temp_Table5007FE, replace every(1)
	
*/			
			
foreach var_bloc in ///
				"turnmig_rate" ///
				"share_age_0_24 share_age_55plus" ///
				"WVS_index_1 WVS_index_2 WVS_index_3" ///	
				"year_school share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  hh_size home_own_rate netmig_rate urban_share_500_y1990 logY_ppp   mlog_road_density city_nuts capital" ///				
				{			
					
					foreach var in 	shock_ld8 shock_rl shock_tfp ///
						bwimf_grr_apw_1970 BW_newep_1970 ///				
						WVS_index_1 WVS_index_2 WVS_index_3 ///	
						{
					


							* generate interactions
							capture drop inter_*
							local counter1=1
							foreach var_bloc_s of varlist `var_bloc' {
									capture drop inter_`counter1'
									gen inter_`counter1' = `var'*`var_bloc_s'
									local counter1=`counter1'+1
								}

							* run regression: baseline + interactions
							reg  ue2_hyst  ///
								turnmig_rate ///
								share_age_0_24 share_age_55plus ///	
								WVS_index_2 ///
								year_school ///		
								share_emp_primary_sector share_emp_secondary_sector  ///
								ic_EMP_share_female  hh_size home_own_rate ///		
								netmig_rate urban_share_500_y1990 ///
								logY_ppp  mlog_road_density city_nuts capital ///
								`var' ///
								cid_* [aw=pop_wgt]  if smpl2==1 & year==1971, robust 
							local R2_base=e(r2)	
				
							* run regression: baseline + interactions
							reg  ue2_hyst  ///
								turnmig_rate ///
								share_age_0_24 share_age_55plus ///	
								WVS_index_2 ///
								year_school ///		
								share_emp_primary_sector share_emp_secondary_sector  ///
								ic_EMP_share_female  hh_size home_own_rate ///		
								netmig_rate urban_share_500_y1990 ///
								logY_ppp  mlog_road_density city_nuts capital ///
								inter_* ///
								`var' ///
								cid_* [aw=pop_wgt]  if smpl2==1 & year==1971, robust  
						
							local R2_`var'=e(r2)
							local ll_`var'=e(ll)
							testparm inter_*
							local F_`var'=r(F)
							local p_`var'=round(r(p)*1000)/1000
							
							local t1=r(p) 
							
							local DR2_`var'=e(r2)-`R2_base'
							local Dll_`var'=e(ll)-`ll_base'
							
							if abs(`t1')<=0.1 {
									local c_`var'=string(`DR2_`var'',"%4.3f")+"*"
							}	
							if abs(`t1')<=0.05 {
									local c_`var'=string(`DR2_`var'',"%4.3f")+"**"
							}		
							if abs(`t1')<=0.01 {
									local c_`var'=string(`DR2_`var'',"%4.3f")+"***"
							}

							if abs(`t1')>0.1 {
									local c_`var'=string(`DR2_`var'',"%4.3f")
							}	
								
				}
				
				
				post `1' ("`var_bloc'") ///
								("`c_shock_ld8'") ("`c_shock_rl'") ("`c_shock_tfp'") ///
								("`c_bwimf_grr_apw_1970'") ("`c_BW_newep_1970'") ///				
								("`c_WVS_index_1'") ("`c_WVS_index_2'") ("`c_WVS_index_3'")

				
			
}					


postclose `1'



*==============================================================
*					BIC
*==============================================================

					
tempname 1 
postfile `1' str100 var_bloc ///
			str10 c_shock_ld8 str10 c_shock_rl str10 c_shock_tfp ///
			str10 c_bwimf_grr_apw_1970 str10 c_BW_newep_1970 ///				
			str10 c_WVS_index_1 str10 c_WVS_index_2 str10 c_WVS_index_3 ///
			using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\output_dta\temp_Table5007_BIC, replace every(1)
	
capture drop ones			
gen ones=1	
capture drop zeros			
gen zeros=1			
foreach var_bloc in ///
				"turnmig_rate" ///
				"share_age_0_24 share_age_55plus" ///
				"WVS_index_1 WVS_index_2 WVS_index_3" ///	
				"year_school share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  hh_size home_own_rate netmig_rate urban_share_500_y1990 logY_ppp   mlog_road_density city_nuts capital" ///				
				"ones" ///
				"zeros" ///
				{			
					
					foreach var in 	shock_ld8 shock_rl shock_tfp ///
						bwimf_grr_apw_1970 BW_newep_1970 ///				
						WVS_index_1 WVS_index_2 WVS_index_3 ///	
						{
					


							* generate interactions
							capture drop inter_*
							local counter1=1
							foreach var_bloc_s of varlist `var_bloc' {
									capture drop inter_`counter1'
									gen inter_`counter1' = `var'*`var_bloc_s'
									local counter1=`counter1'+1
								}

							* run regression: baseline + interactions
							reg  ue2_hyst  ///
								turnmig_rate ///
								share_age_0_24 share_age_55plus ///	
								WVS_index_2 ///
								year_school ///		
								share_emp_primary_sector share_emp_secondary_sector  ///
								ic_EMP_share_female  hh_size home_own_rate ///		
								netmig_rate urban_share_500_y1990 ///
								logY_ppp  mlog_road_density city_nuts capital ///
								`var' ///
								[aw=pop_wgt]  if smpl2==1 & year==1971, robust 
							local R2_base=e(r2)	
				
							* run regression: baseline + interactions
							reg  ue2_hyst  ///
								turnmig_rate ///
								share_age_0_24 share_age_55plus ///	
								WVS_index_2 ///
								year_school ///		
								share_emp_primary_sector share_emp_secondary_sector  ///
								ic_EMP_share_female  hh_size home_own_rate ///		
								netmig_rate urban_share_500_y1990 ///
								logY_ppp  mlog_road_density city_nuts capital ///
								inter_* ///
								`var' ///
								[aw=pop_wgt]  if smpl2==1 & year==1971, robust  
						
													
							local DR2_`var'=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)
							di "BIC: `DR2_`var''"
							local c_`var'=string(`DR2_`var'',"%4.3f")


							
				}
				
				
				post `1' ("`var_bloc'") ///
								("`c_shock_ld8'") ("`c_shock_rl'") ("`c_shock_tfp'") ///
								("`c_bwimf_grr_apw_1970'") ("`c_BW_newep_1970'") ///				
								("`c_WVS_index_1'") ("`c_WVS_index_2'") ("`c_WVS_index_3'")

				
			
}					


postclose `1'


*==============================================================
*				BIC & Country fixed effects
*==============================================================

					
tempname 1 
postfile `1' str100 var_bloc ///
			str10 c_shock_ld8 str10 c_shock_rl str10 c_shock_tfp ///
			str10 c_bwimf_grr_apw_1970 str10 c_BW_newep_1970 ///				
			str10 c_WVS_index_1 str10 c_WVS_index_2 str10 c_WVS_index_3 ///
			using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\output_dta\temp_Table5007_BICFE, replace every(1)
	
capture drop ones			
gen ones=1	
capture drop zeros
gen zeros=1	
foreach var_bloc in ///
				"turnmig_rate" ///
				"share_age_0_24 share_age_55plus" ///
				"WVS_index_1 WVS_index_2 WVS_index_3" ///	
				"year_school share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  hh_size home_own_rate netmig_rate urban_share_500_y1990 logY_ppp   mlog_road_density city_nuts capital" ///				
				"ones" ///
				"zeros" ///				
				{			
					
					foreach var in 	shock_ld8 shock_rl shock_tfp ///
						bwimf_grr_apw_1970 BW_newep_1970 ///				
						WVS_index_1 WVS_index_2 WVS_index_3 ///	
						{
					


							* generate interactions
							capture drop inter_*
							local counter1=1
							foreach var_bloc_s of varlist `var_bloc' {
									capture drop inter_`counter1'
									gen inter_`counter1' = `var'*`var_bloc_s'
									local counter1=`counter1'+1
								}

							* run regression: baseline + interactions
							reg  ue2_hyst  ///
								turnmig_rate ///
								share_age_0_24 share_age_55plus ///	
								WVS_index_2 ///
								year_school ///		
								share_emp_primary_sector share_emp_secondary_sector  ///
								ic_EMP_share_female  hh_size home_own_rate ///		
								netmig_rate urban_share_500_y1990 ///
								logY_ppp  mlog_road_density city_nuts capital ///
								`var' ///
								cid_* [aw=pop_wgt]  if smpl2==1 & year==1971, robust 
							local R2_base=e(r2)	
				
							* run regression: baseline + interactions
							reg  ue2_hyst  ///
								turnmig_rate ///
								share_age_0_24 share_age_55plus ///	
								WVS_index_2 ///
								year_school ///		
								share_emp_primary_sector share_emp_secondary_sector  ///
								ic_EMP_share_female  hh_size home_own_rate ///		
								netmig_rate urban_share_500_y1990 ///
								logY_ppp  mlog_road_density city_nuts capital ///
								inter_* ///
								`var' ///
								cid_* [aw=pop_wgt]  if smpl2==1 & year==1971, robust  
						
													
							local DR2_`var'=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)
							di "BIC: `DR2_`var''"
							local c_`var'=string(`DR2_`var'',"%4.3f")


							
				}
				
				
				post `1' ("`var_bloc'") ///
								("`c_shock_ld8'") ("`c_shock_rl'") ("`c_shock_tfp'") ///
								("`c_bwimf_grr_apw_1970'") ("`c_BW_newep_1970'") ///				
								("`c_WVS_index_1'") ("`c_WVS_index_2'") ("`c_WVS_index_3'")

				
			
}					


postclose `1'

